<HTML><HEAD><TITLE>TinyUnit unit test page</TITLE><META NAME= "robots" CONTENT= "noindex, nofollow"><LINK REV= "made" HREF= "mailto:w-p@dds.nl"><META NAME= "keywords" content= ""><META NAME= "robots" CONTENT= "noindex, nofolow">
</HEAD><BODY><CENTER><H1>TinyUnit unit test page</H1></CENTER>
<P><?php
require_once("TinyUnit.php");

class clsMockTest extends AbstractTest
{private $mstrLog = '';
 public function __toString()
         {return '[unit test mock object]';}
 public function run()
         {$this->getDriver()->startClass('clsMockTest');
          $this->getDriver()->startMethod('run');
          $this->getDriver()->should(TRUE,'should pass');
          $this->getDriver()->should(FALSE,'should fail');
          $this->getDriver()->shouldnt(TRUE,'shouldnt pass');
          $this->getDriver()->shouldnt(FALSE,'shouldnt fail');
          $this->getDriver()->remark('Never take it all.');
          $this->mstrLog .= '[run]';
          return $this->getDriver()->endMethod(); }
 protected function setup()
         {$this->mstrLog .= '[setup]';}
 protected function teardown()
         {$this->mstrLog .= '[teardown]';}
 public function actionLog()
         {return $this->mstrLog;}
} // class clsMockTest

class tclDriver extends AbstractTest implements TestResultListener //self-shunt pattern
{private $mobjTest;
 private $mobjMockTest;
 private $mstrStartLog = '';
 private $mstrIntermediateLog = '';
 private $mstrEndLog = '';
 private $mstrRemarkLog = '';
 public function __toString()
         {return '[Testdriver object unit test]';}
 private function booleanToString($ysn)
         {if($ysn)
            {$strResult = 'TRUE';}
          else
            {$strResult = 'FALSE';}
          return $strResult; }
 public function logStartOfMethod($strClassName,$strMethodName)
         {$this->mstrStartLog .= '[' . $strClassName . '->' . $strMethodName . ']';}
 public function logIntermediate($strDescription,$ysnHasPassed)
         {$this->mstrIntermediateLog .= '[' . $strDescription . ':' . $this->booleanToString($ysnHasPassed) . ']';}
 public function logEndOfMethod($ysnMethodPassed)
         {$this->mstrEndLog .= '[' . $this->booleanToString($ysnMethodPassed) . ']';}
 public function logRemark($strMessage)
         {$this->mstrRemarkLog .= '[' . $strMessage . ']';}
 public function run() // overridden
         {$this->getDriver()->startClass('TestDriver');
          $this->mobjMockTest = new clsMockTest;
          $ysnResult = $this->testConstructor();
          $ysnResult = ($this->testTempPath() and $ysnResult);
          $ysnResult = ($this->testRun() and $ysnResult);
          $ysnResult = ($this->testStartClass() and $ysnResult);
          $ysnResult = ($this->testStartMethod() and $ysnResult);
          $ysnResult = ($this->testShould() and $ysnResult);
          $ysnResult = ($this->testShouldnt() and $ysnResult);
          $ysnResult = ($this->testRemark() and $ysnResult);
          $ysnResult = ($this->testEndMethod() and $ysnResult);
          return $ysnResult; }
 private function testConstructor()
         {$this->getDriver()->startMethod('(constructor)');
          $ysnCaught=FALSE;
          try{$this->mobjTest = new TestDriver($this->mobjMockTest);}
          catch(Exception $excCaught)
             {$ysnCaught=TRUE;}
          $this->getDriver()->shouldnt($ysnCaught,'No errors: normal use.');
          $this->getDriver()->should(get_class($this->mobjTest) == 'TestDriver', 'Type is TestDriver.');
          return $this->getDriver()->endMethod(); }
 private function testEndMethod()
         {$this->getDriver()->startMethod('endMethod');
          $this->getDriver()->should($this->mstrEndLog == '[FALSE]', 'End of method was logged');
          return $this->getDriver()->endMethod(); }
 private function testRun()
         {$this->getDriver()->startMethod('run');
          $this->getDriver()->shouldnt($this->mobjTest->run($this), 'Some methods of the mock test fail.');
          $this->getDriver()->should($this->mobjMockTest->actionLog() == '[setup][run][teardown]', 'Setup, run and teardown methods are called.');
          return $this->getDriver()->endMethod(); }
 private function testRemark()
         {$this->getDriver()->startMethod('remark');
          $this->getDriver()->should($this->mstrRemarkLog == '[Never take it all.]', 'remark was logged');
          return $this->getDriver()->endMethod(); }
 private function testStartClass()
         {$this->getDriver()->startMethod('startClass');
          $this->getDriver()->should($this->mstrStartLog == '[clsMockTest->run]', 'Class name was logged.');
          return $this->getDriver()->endMethod(); }
 private function testStartMethod()
         {$this->getDriver()->startMethod('startMethod');
          $this->getDriver()->should($this->mstrStartLog == '[clsMockTest->run]', 'Class name was logged.');
          return $this->getDriver()->endMethod(); }
 private function testShould()
         {$this->getDriver()->startMethod('should');
          $this->getDriver()->should(substr($this->mstrIntermediateLog,0,37) == '[should pass:TRUE][should fail:FALSE]', 'result of should method was logged.');
          return $this->getDriver()->endMethod(); }
 private function testShouldnt()
         {$this->getDriver()->startMethod('shouldnt');
          $this->getDriver()->should(substr($this->mstrIntermediateLog,-41) == '[shouldnt pass:FALSE][shouldnt fail:TRUE]', 'result of shouldnt method was logged.');
          return $this->getDriver()->endMethod(); }
 private function testTempPath()
         {$this->getDriver()->startMethod('tempPath');
          $this->getDriver()->should($this->mobjTest->tempPath() == $_ENV['TMP'] . '\\','Temporary path is read from environment variable and end is a slash.');
          return $this->getDriver()->endMethod(); }
 protected function teardown()
         {unset($this->mobjTest);
          unset($this->mobjMockTest); } // overridden
} // class tclDriver

class tclSuite extends AbstractTest implements TestResultListener //self-shunt pattern
{private $mobjTest;
 private $mobjMockTest;
 private $mstrStartLog = '';
 private $mstrIntermediateLog = '';
 private $mstrEndLog = '';
 private $mstrRemarkLog = '';
 public function __toString()
         {return '[Test suite unit test]';}
 private function booleanToString($ysn)
         {if($ysn)
            {$strResult = 'TRUE';}
          else
            {$strResult = 'FALSE';}
          return $strResult; }
 public function logStartOfMethod($strClassName,$strMethodName)
         {$this->mstrStartLog .= '[' . $strClassName . '->' . $strMethodName . ']';}
 public function logIntermediate($strDescription,$ysnHasPassed)
         {$this->mstrIntermediateLog .= '[' . $strDescription . ':' . $this->booleanToString($ysnHasPassed) . ']';}
 public function logEndOfMethod($ysnMethodPassed)
         {$this->mstrEndLog .= '[' . $this->booleanToString($ysnMethodPassed) . ']';}
 public function logRemark($strMessage)
         {$this->mstrRemarkLog .= '[' . $strMessage . ']';}
 public function run() // overridden
         {$this->getDriver()->startClass('TestSuite');
          $this->mobjMockTest=new clsMockTest;
          $ysnResult = $this->testConstructor();
          $ysnResult = ($this->testAdd() and $ysnResult);
          return $ysnResult; }
 private function testAdd()
         {$this->getDriver()->startMethod('add');
          $ysnCaught = FALSE;
          try{$this->mobjTest->add($this->mobjMockTest);}
          catch(Exception $excWhatEver)
             {$ysnCaught = TRUE;}
          $this->getDriver()->shouldnt($ysnCaught ,'No errors.');
          return $this->getDriver()->endMethod(); }
 private function testConstructor()
         {$this->getDriver()->startMethod('(constructor)');
          $ysnCaught = FALSE;
          try{$this->mobjTest = new TestSuite(NULL); }
          catch(Exception $excWhatEver)
             {$ysnCaught = TRUE;}
          $this->getDriver()->should($ysnCaught ,'Error: name cannot be NULL.');
          $ysnCaught = FALSE;
          try{$this->mobjTest = new TestSuite(''); }
          catch(Exception $excWhatEver)
             {$ysnCaught = TRUE;}
          $this->getDriver()->should($ysnCaught ,'Error: name cannot be an empty string.');
          $ysnCaught = FALSE;
          try{$this->mobjTest = new TestSuite('Sooeet'); }
          catch(Exception $excWhatEver)
             {$ysnCaught = TRUE;}
          $this->getDriver()->shouldnt($ysnCaught ,'No errors. Normal use.');
          return $this->getDriver()->endMethod(); }
 protected function teardown()
         {unset($this->mobjTest);
          unset($this->mobjMockTest); } // overridden
} // class tclSuite

class clsTestOutput implements TestResultListener
{private $mobjDriver;
 private $mobjSuite;
 private $mnumTests=0;
 private $mdtmStart;
 public function __construct()
         {$this->mobjSuite = new TestSuite('TinyUnit');
          $this->mobjSuite->add(new tclDriver);
          $this->mobjSuite->add(new tclSuite);
          $this->mobjDriver = new TestDriver($this->mobjSuite);
         }
 public function run()
         {$this->mdtmStart=time();
          $ysnResult = $this->mobjDriver->run($this);
          echo $this->mnumTests;
          echo ' tests ran in ';
          echo time()-$this->mdtmStart;
          echo ' seconds.';
          if($ysnResult)
            {echo ' All tests passed.';}
          else
            {echo ' Some tests failed.';}
          echo '<BR>'; }
 public function logStartOfMethod($strClassName,$strMethodName)
         {echo 'Testing ' . $strClassName . '->' . $strMethodName . '...<BR>';} // overridden
 public function logIntermediate($strDescription,$ysnHasPassed)
         {if($ysnHasPassed)
            {echo '<FONT color= #008000>&nbsp; &nbsp; OK: ' . $strDescription . '</FONT><BR>';}
          else
            {echo '<FONT color= #ff0000><STRONG>FAILED:</STRONG> ' . $strDescription . '</FONT><BR>';}
         }
 public function logEndOfMethod($ysnHasMethodTestPassed)
         {$this->mnumTests++;
          if($ysnHasMethodTestPassed)
            {echo '<FONT color= #004000>&nbsp; &nbsp; Method test passed.</FONT><BR>';}
          else
            {echo '<FONT color= #800000><STRONG>Method test failed.</STRONG></FONT><BR>';}
         }
 public function logRemark($strMessage)
         {echo $strMessage;
          echo '<BR>'; }
}
$dummy=new clsTestOutput;
$dummy->run();
?></P>
</BODY></HTML>
