<?php
class ArgumentException extends Exception
{function __construct($class='', $method='', $parameter='', $message = '', $code = 0)
         {parent::__construct('Invalid argument value in ' . $class . '->' . $method . ', parameter ' . $parameter . ': ' . $message, $code );}
}

interface TestResultListener
{
 public function logStartOfMethod($strClassName,$strMethodName);
 public function logIntermediate($strDescription,$ysnHasPassed);
 public function logEndOfMethod($ysnMethodPassed);
 public function logRemark($strMessage);
} //abstract class TestResultListener

class TestDriver
{private $mobjSuite;
 private $mstrCurrentClass;
 private $mstrCurrentMethod;
 private $mstrTempPath;
 private $mysnCurrentMethodState;
 private $mobjListener;
 public function __construct(AbstractTest $objSuite)
         {if(is_null($objSuite))
            {throw new ArgumentException(__CLASS__, __FUNCTION__, '$objSuite', 'No test class given.');}
          $this->mobjSuite = $objSuite; }
 public function run(TestResultListener $objListener)
         {if(is_null($objListener))
            {throw new ArgumentException(__CLASS__, __FUNCTION__, '$objListener', 'No listener given.');}
          $ysnResult=FALSE;
          $this->mobjListener = $objListener;
          try{$this->mobjSuite->setDriver($this);
              $ysnResult = $this->mobjSuite->run();
              $this->mobjSuite->dispose();
              unset($this->mobjListener);}
          catch(Exception $excWhatEver)
             {$ysnResult = FALSE;
              $this->shouldnt(TRUE,'Unexpected exception occurred: ' . $excWhatEver->getMessage()); }
          return $ysnResult; }
 public function should($ysnHasPassed, $strDescription)
         {$this->mysnCurrentMethodState = ($this->mysnCurrentMethodState and $ysnHasPassed);
          $this->mobjListener->logIntermediate($strDescription, $ysnHasPassed); }
 public function shouldnt($ysnHasPassed, $strDescription)
         {$this->mysnCurrentMethodState = ($this->mysnCurrentMethodState and !$ysnHasPassed);
          $this->mobjListener->logIntermediate($strDescription, !$ysnHasPassed); }
 public function startClass($strName)
         {$this->mstrCurrentClass = $strName;}
 public function startMethod($strName)
         {$this->mstrCurrentMethod = $strName;
          $this->mysnCurrentMethodState = TRUE;
          $this->mobjListener->logStartOfMethod($this->mstrCurrentClass,$this->mstrCurrentMethod); }
 public function tempPath()
         {if($this->mstrTempPath == '')//lazy evaluation
            {$this->mstrTempPath = $this->EnforceSlash($_ENV['TMP']);}
          return $this->mstrTempPath; }
 private function EnforceSlash($path)
         {if(strpos($path,':\\'))
            {if(substr($path,-1) != '\\')
               {$path = $path . '\\';} }
          else
            {if(substr($path,-1) != '/')
               {$path = $path . '/';} }
          return $path; }
 public function endMethod()
         {$this->mobjListener->logEndOfMethod($this->mysnCurrentMethodState);
          return $this->mysnCurrentMethodState; }
 public function remark($strRemark)
         {$this->mobjListener->logRemark($strRemark);}
} // class TestDriver

abstract class AbstractTest // abstract
{private $mobjDriver;
 final public function dispose() // friend: only called from within TinyUnit
         {$this->teardown();
          unset($this->mobjDriver); }
 final protected function getDriver()
         {return $this->mobjDriver;}
 abstract public function run(); // abstract. Return a boolean.
 final public function setDriver(TestDriver $objDriver) // friend: only called from within TinyUnit
         {$this->mobjDriver = $objDriver;
          $this->setup(); }
 protected function setup(){} // protected; Meant to be overridden if necessary
 protected function teardown(){}// protected; Meant to be overridden if necessary
} // abstract class AbstractTest

class TestSuite extends AbstractTest // a collection of test classes.
{private $mobjTests; // array of AbstractTest objects
 private $mstrName; // Name of this collection of tests, such as a package name.
 public function add(AbstractTest $objTest)
         {if(is_null($objTest))
            {throw new ArgumentException(__CLASS__, __FUNCTION__, '$objTest', 'No test class given.');}
          $this->mobjTests[] = $objTest;}
 public function __construct($strName)
         {if(! is_string($strName))
            {throw new ArgumentException(__CLASS__, __FUNCTION__, '$strName', 'Not a string.');}
          if(strlen($strName)<1)
            {throw new ArgumentException(__CLASS__, __FUNCTION__, '$strName', 'The name cannot be an empty string.');}
          $this->mstrName = $strName;}
 private function handleSingleTest(AbstractTest $objTest)
         {$ysnResult = FALSE;
          $ysnContinue = $this->setupSucceeded($objTest);
          if($ysnContinue)
            {$ysnResult = $this->runSingleTest($objTest);}
          try{$objTest->dispose();}
          catch(Exception $excWhatEver)
             {$ysnResult=FALSE;
              $this->getDriver()->shouldnt(TRUE,'Teardown failed: ' . $excWhatEver->getMessage()); }
          return $ysnResult; }
 public function run()
         {$objTest=NULL;
          $ysnResult=TRUE;
          foreach($this->mobjTests as $objTest)
                 {$ysnResult = ($this->handleSingleTest($objTest) and $ysnResult);}
          return $ysnResult;
         }
 private function runSingleTest(AbstractTest $objTest)
         {$ysnResult = FALSE;
          try{$ysnResult = $objTest->run(); }
          catch(Exception $excWhatEver)
             {$ysnResult=FALSE;
              $this->getDriver()->shouldnt(TRUE,'Untrapped exception: ' . $excWhatEver->getMessage());
              $this->getDriver()->endMethod(); }
          return $ysnResult; }
 protected function setup()
         {$this->getDriver()->remark("Starting suite $this->mstrName ...");}
 private function setupSucceeded(AbstractTest $objTest)
         {$ysnResult = TRUE;
          try{$objTest->setDriver($this->getDriver());}
          catch(Exception $excWhatEver)
             {$ysnResult=FALSE;
              $this->getDriver()->shouldnt(TRUE,'Setup failed: ' . $excWhatEver->getMessage()); }
          return $ysnResult;
         }
 protected function teardown()
         {$this->getDriver()->remark("Finished suite $this->mstrName .");}
} // class TestSuite
?>
