VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "ClsErrorLog"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Compare Binary
Option Explicit
'class clsErrorLog
'$Archive: /Test/TestJava2VB/ClsErrorLog.cls $
'$Author: Dikkie Dik $
'$Date: 7/02/05 0:39 $
'$Revision: 9 $

Private Const mERRBASE As Long = -2147217812 'EL
Private Const mERR_ALREADY_CONSTRUCTED As Long = mERRBASE + 1

Private mintEmployeeNr As Integer
Private mstrLogFile As String
Private mysnInProcessMode As Boolean
Private mysnIsConstruted As Boolean

Public Enum enmErrorMode
    SILENTMODE_ON = 0
    SILENTMODE_OFF = 1
End Enum

Private Sub Class_Initialize()
 On Error Resume Next
 mstrLogFile = App.Path & "\" & App.EXEName & ".log"
 mintEmployeeNr = GetCurrentUserId
 mysnInProcessMode = False
End Sub

Public Sub Construct(Optional ByVal strFileName As String = "", Optional ByVal ysnProcess As Boolean = False)
Attribute Construct.VB_Description = "The constructor"
 If mysnIsConstruted Then Err.Raise mERR_ALREADY_CONSTRUCTED, App.EXEName & ".ClsErrorLog.construct", "Construct method can only be used once."
 If Len(strFileName) = 0 Then strFileName = App.EXEName & ".LOG"
 If InStr(1, strFileName, "\") = 0 Then strFileName = App.Path & "\" & strFileName
 mstrLogFile = strFileName
 mysnInProcessMode = ysnProcess
 mysnIsConstruted = True
End Sub

Private Property Get GetCurrentUserId() As Integer
 GetCurrentUserId = Val(Environ$("WNR"))
End Property

Public Property Get IsInDevelopmentMode() As Boolean
 #If gysnDevelop Then
    IsInDevelopmentMode = True
 #ElseIf gysnDebug Then
    IsInDevelopmentMode = True
 #Else
    IsInDevelopmentMode = False
 #End If
End Property

Public Property Get IsRunningInIDE() As Boolean
 On Error Resume Next
 Debug.Print 1 / 0
 IsRunningInIDE = (Err.Number <> 0)
End Property

Public Sub LogError(ByVal strLogPosition As String, ByVal bytSilentMode As enmErrorMode)
 WriteError Err.Description, strLogPosition & " (" & Err.Source & ")", bytSilentMode
End Sub

Public Sub WriteError(ByVal strMessage As String, ByVal strForm As String, ByVal bytSilentMode As enmErrorMode)
Attribute WriteError.VB_Description = "DEPRECATED. use logError instead."
Attribute WriteError.VB_MemberFlags = "40"
'DEPRECATED. Use logError instead.
'Writes an error message to a log file. The log file is located in the same directory
'as the application and has the same name, but an extension ".log". If bytSilentMode
'is not SILENTMODE_OFF, then the user gets a warning.
 On Error Resume Next 'No recursive error calls
 WriteErrorToFile strMessage, strForm
 If bytSilentMode = enmErrorMode.SILENTMODE_OFF And Not mysnInProcessMode Then
   MsgBox strMessage, 4112, strForm
 End If
End Sub

Private Sub WriteErrorToFile(ByVal strMessage As String, ByVal strForm As String)
 On Error GoTo Err_writeErrorToFile
 Dim intFileNumber As Integer
 intFileNumber = FreeFile
 Open mstrLogFile For Append As #intFileNumber
 On Error GoTo close_first
 Print #intFileNumber, Format$(Now, "yyyy mmm d ddd - hh:nn:ss"); " -> "; strMessage; " ; "; strForm; _
                       IIf(mintEmployeeNr <> 0, " ; User: " & mintEmployeeNr, "")
 Close #intFileNumber
Exit_writeErrorToFile:
 Exit Sub
close_first:
 On Error Resume Next
 Close #intFileNumber
Err_writeErrorToFile:
 MsgBox "Unable to log the next error. Please inform the software department.", vbExclamation, "Important!"
 Resume Exit_writeErrorToFile
End Sub
