VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsTestDriver"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit
'public class clsTestDriver
'$Archive: /TinyUnit/clsTestDriver.cls $
'$Author: Dikkie Dik $
'$Date: 19/02/05 19:30 $
'$Revision: 11 $

Private Const mERRBASE As Long = -2147207880 'TD
Private Const mERR_NOT_CONSTRUCTED As Long = mERRBASE
Private Const mERR_ALREADY_CONSTRUCTED As Long = mERRBASE + 1
Private Const mERR_WRONG_PARAMETER As Long = mERRBASE + 2

Private mstrCurrentClass As String
Private mstrCurrentMethod As String
Private mstrTempPath As String
Private mysnCurrentMethodState As Boolean
Private mysnIsConstructed As Boolean
Private mobjSuite As ifcTestable

Private Declare Function apiGetTempPath Lib "kernel32.dll" Alias "GetTempPathA" (ByVal lngBufferLength As Long, ByVal strBuffer As String) As Long

Public Event OnStartMethodTest(ByVal strClass As String, ByVal strMethod As String)
Public Event OnEndMethodTest(ByVal ysnResult As Boolean)
Public Event OnLogIntermediate(ByVal strDescription As String, ByVal ysnResult As Boolean)

Private Sub CheckIfConstructed()
 If Not mysnIsConstructed Then Err.Raise mERR_NOT_CONSTRUCTED, App.EXEName & ".clsTestDriver.CheckIfConstructed", "Programmer's error: clsTestDriver object is not constructed."
End Sub

Friend Sub Construct(ByVal objSuite As ifcTestable)
 If mysnIsConstructed Then Err.Raise mERR_ALREADY_CONSTRUCTED, App.EXEName & ".clsTestDriver.Construct", "Programmer's error: clsTestDriver object was already constructed."
 If objSuite Is Nothing Then Err.Raise mERR_WRONG_PARAMETER, App.EXEName & ".clsTestDriver.Construct", "No test suite was given."
 Set mobjSuite = objSuite
 mysnIsConstructed = True
End Sub

Public Function EndMethod() As Boolean
 CheckIfConstructed
 RaiseEvent OnEndMethodTest(mysnCurrentMethodState)
 mstrCurrentMethod = ""
End Function

Public Function Run() As Boolean
 CheckIfConstructed
 With mobjSuite
     .Setup Me
     On Error Resume Next
     Run = .Run
     If Err.Number <> 0 Then Run = False
     On Error GoTo 0
     .TearDown
 End With
End Function

Public Sub Should(ByVal ysnResult As Boolean, ByVal strDescription As String)
 CheckIfConstructed
 If Len(strDescription) = 0 Then Err.Raise mERR_WRONG_PARAMETER, App.EXEName & ".clsTestDriver.Should", "No description was given. Descriptions are necessary to locate the defects and for documentation."
 mysnCurrentMethodState = mysnCurrentMethodState And ysnResult
 RaiseEvent OnLogIntermediate(strDescription, ysnResult)
End Sub

Public Sub Shouldnt(ByVal ysnResult As Boolean, ByVal strDescription As String)
 CheckIfConstructed
 If Len(strDescription) = 0 Then Err.Raise mERR_WRONG_PARAMETER, App.EXEName & ".clsTestDriver.Shouldnt", "No description was given. Descriptions are necessary to locate the defects and for documentation."
 mysnCurrentMethodState = mysnCurrentMethodState And Not ysnResult
 RaiseEvent OnLogIntermediate(strDescription, Not ysnResult)
End Sub

Public Sub StartClass(ByVal strName As String)
 CheckIfConstructed
 If Len(strName) = 0 Then Err.Raise mERR_WRONG_PARAMETER, App.EXEName & ".clsTestDriver.StartClass", "No class name was given."
 mstrCurrentClass = strName
End Sub

Public Sub StartMethod(ByVal strName As String)
 CheckIfConstructed
 If Len(strName) = 0 Then Err.Raise mERR_WRONG_PARAMETER, App.EXEName & ".clsTestDriver.StartMethod", "No method name was given."
 mstrCurrentMethod = strName
 mysnCurrentMethodState = True
 RaiseEvent OnStartMethodTest(mstrCurrentClass, mstrCurrentMethod)
End Sub

Public Property Get TempPath() As String
 Const BUFLEN = 254
 Dim strBuffer As String * BUFLEN
 CheckIfConstructed
 If Len(mstrTempPath) = 0 Then
   If apiGetTempPath(BUFLEN, strBuffer) <> 0 Then
     mstrTempPath = Left$(strBuffer, InStr(1, strBuffer, Chr$(0), vbBinaryCompare) - 1)
   End If
 End If
 TempPath = mstrTempPath
End Property
