VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsTestSuite"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit
'public class clsTestSuite
'$Archive: /TinyUnit/clsTestSuite.cls $
'$Author: Dikkie Dik $
'$Date: 19/02/05 19:30 $
'$Revision: 7 $

Implements ifcTestable

Private Const mERRBASE As Long = -2147207490 'TS
Private Const mERR_NOT_CONSTRUCTED As Long = mERRBASE
Private Const mERR_ALREADY_CONSTRUCTED As Long = mERRBASE + 1
Private Const mERR_WRONG_PARAMETER As Long = mERRBASE + 2

Private mobjTests() As ifcTestable
Private mobjDriver As clsTestDriver
Private mstrName As String
Private mysnIsConstructed As Boolean

Public Sub Add(ByVal objTest As ifcTestable)
 Dim lngCount As Long
 CheckIfConstructed
 If objTest Is Nothing Then Err.Raise mERR_WRONG_PARAMETER, App.EXEName & ".clsTestSuite.Add", "No test suite was given"
 lngCount = UBound(mobjTests)
 Set mobjTests(lngCount) = objTest
 ReDim Preserve mobjTests(0 To lngCount + 1)
End Sub

Private Sub CheckIfConstructed()
 If Not mysnIsConstructed Then Err.Raise mERR_NOT_CONSTRUCTED, App.EXEName & ".clsTestSuite.CheckIfConstructed", "Programmer's error: clsTestSuite object is not constructed."
End Sub

Private Sub Class_Initialize()
 ReDim mobjTests(0 To 0)
End Sub

Private Sub Class_Terminate()
 Dim lngCount As Long
 lngCount = UBound(mobjTests)
 While lngCount >= 0
      Set mobjTests(lngCount) = Nothing
      lngCount = lngCount - 1
 Wend
 Erase mobjTests
End Sub

Friend Sub Construct(ByVal strName As String)
 If mysnIsConstructed Then Err.Raise mERR_ALREADY_CONSTRUCTED, App.EXEName & ".clsTestSuite.Construct", "Programmer's error: clsTestSuite object was already constructed."
 If Len(strName) = 0 Then Err.Raise mERR_WRONG_PARAMETER, App.EXEName & ".clsTestSuite.ifcTestable_Setup"
 mstrName = strName
 mysnIsConstructed = True
End Sub

Private Function ifcTestable_Run() As Boolean
 Dim lngCount As Long
 Dim ysnResult As Boolean
 CheckIfConstructed
 lngCount = 0
 ysnResult = True 'Nothing failed yet
 While lngCount < UBound(mobjTests)
      PerformTest mobjTests(lngCount), ysnResult
      lngCount = lngCount + 1
 Wend
 ifcTestable_Run = ysnResult
End Function

Private Sub ifcTestable_Setup(ByVal objDriver As clsTestDriver)
 CheckIfConstructed
 If objDriver Is Nothing Then Err.Raise mERR_WRONG_PARAMETER, App.EXEName & ".clsTestSuite.ifcTestable_Setup", "Test suite parent cannot be empty."
 Set mobjDriver = objDriver
 mobjDriver.Should True, "Starting suite """ & mstrName & """..."
End Sub

Private Sub ifcTestable_TearDown()
 mobjDriver.Should True, "Finished suite """ & mstrName & """."
 Set mobjDriver = Nothing
End Sub

Private Property Get Name() As String
 CheckIfConstructed
 Name = mstrName
End Property

Private Sub PerformTest(ByVal objTest As ifcTestable, ByRef ysnPassed As Boolean)
 On Error GoTo ERR_PerformTest
 With objTest
     .Setup mobjDriver
     ysnPassed = ysnPassed And .Run
     .TearDown
 End With
 Exit Sub
ERR_PerformTest:
 mobjDriver.Should False, "Error occurred: """ & Err.Description & """ (code " & Err.Number & ", raised by " & Err.Source & ")"
 Resume Next
End Sub
