Public Class clsTestDriver
    Public Event OnStartMethodTest(ByVal strClass As String, ByVal strMethod As String)
    Public Event OnLogIntermediate(ByVal strDescription As String, ByVal ysnResult As Boolean)
    Public Event OnEndMethodTest(ByVal ysnResult As Boolean)

    Private mstrCurrentClass As String
    Private mstrCurrentMethod As String
    Private mstrTempPath As String
    Private mysnCurrentMethodState As Boolean
    Private mobjTest As clsAbstractTest

    Public Function EndMethod() As Boolean
        RaiseEvent OnEndMethodTest(mysnCurrentMethodState)
        mstrCurrentMethod = ""
    End Function

    Public Sub New(ByVal objTest As clsAbstractTest)
        If objTest Is Nothing Then Throw New ArgumentNullException("objTest")
        mobjTest = objTest
    End Sub

    Public Function Run() As Boolean
        With mobjTest
            .SetDriver(Me)
            Try
                Run = .Run
            Catch ex As Exception
                Run = False
                Should(False, "Error occurred: " & ex.Message & " (" & ex.Source & ")")
            End Try
            .Dispose()
        End With
    End Function

    Public Sub Should(ByVal ysnResult As Boolean, ByVal strDescription As String)
        If strDescription Is Nothing Then Throw New ArgumentNullException("strDescription")
        If Len(strDescription) = 0 Then Throw New ArgumentException("strDescription", "No description was given. Descriptions are necessary to locate the defects and for documentation.")
        mysnCurrentMethodState = mysnCurrentMethodState And ysnResult
        RaiseEvent OnLogIntermediate(strDescription, ysnResult)
    End Sub

    Public Sub Shouldnt(ByVal ysnResult As Boolean, ByVal strDescription As String)
        If strDescription Is Nothing Then Throw New ArgumentNullException("strDescription")
        If Len(strDescription) = 0 Then Throw New ArgumentException("strDescription", "No description was given. Descriptions are necessary to locate the defects and for documentation.")
        mysnCurrentMethodState = mysnCurrentMethodState And Not ysnResult
        RaiseEvent OnLogIntermediate(strDescription, Not ysnResult)
    End Sub

    Public Sub StartClass(ByVal strName As String)
        If strName Is Nothing Then Throw New ArgumentNullException("strName")
        If Len(strName) = 0 Then Throw New ArgumentException("strName", "No class name was given.")
        mstrCurrentClass = strName
    End Sub

    Public Sub StartMethod(ByVal strName As String)
        If strName Is Nothing Then Throw New ArgumentNullException("strName")
        If Len(strName) = 0 Then Throw New ArgumentException("strName", "No method name was given.")
        mstrCurrentMethod = strName
        mysnCurrentMethodState = True
        RaiseEvent OnStartMethodTest(mstrCurrentClass, mstrCurrentMethod)
    End Sub

    Public ReadOnly Property TempPath() As String
        Get
            If Len(mstrTempPath) = 0 Then
                With (New System.CodeDom.Compiler.TempFileCollection)
                    mstrTempPath = .TempDir
                End With
            End If
            TempPath = mstrTempPath
        End Get
    End Property
End Class
