Public Class clsTestSuite
    Inherits clsAbstractTest

    Private mobjTests() As clsAbstractTest

    Public Sub Add(ByVal objTest As clsAbstractTest)
        If objTest Is Nothing Then Throw New ArgumentNullException("objTest")
        Dim intCount As Integer = UBound(mobjTests)
        mobjTests(UBound(mobjTests)) = objTest
        ReDim Preserve mobjTests(intCount + 1)
    End Sub

    Public Sub New()
        ReDim mobjTests(0)
    End Sub

    Public Overrides Function Run() As Boolean
        Dim intCount As Integer
        Dim ysnResult As Boolean
        intCount = 0
        ysnResult = True 'nothing failed yet.
        While intCount < UBound(mobjTests)
            With mobjTests(intCount)
                Try
                    .SetDriver(Driver()) 'imlicitely executes Setup method
                Catch ex As Exception
                    Driver.Should(False, "Setup failed: " & ex.Message & " (" & ex.Source & ")")
                End Try
                Try
                    ysnResult = ysnResult And .Run()
                Catch ex As Exception
                    Driver.Should(False, "Unexpected exception during test: " & ex.Message & " (" & ex.Source & ")")
                End Try
                Try
                    .Dispose() 'imlicitely executes Teardown method
                Catch ex As Exception
                    Driver.Should(False, "Teardown failed: " & ex.Message & " (" & ex.Source & ")")
                End Try
                intCount = intCount + 1
            End With
        End While
        Run = ysnResult
    End Function
End Class
